/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/****************************************************************************
 * NCSA HDF                                                                 *
 * National Comptational Science Alliance                                   *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 *                                                                          *
 * For conditions of distribution and use, see the accompanying             *
 * hdf-java/COPYING file.                                                   *
 *                                                                          *
 ****************************************************************************/
package org.broad.igv.preprocess.old;

import org.broad.igv.data.Dataset;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/**
 * Processor for features which might have overlapping loci.  For example,
 * gene expression.
 */
public class OverlappingProcessor extends AbstractProcessor {
    
    static Logger log = Logger.getLogger(OverlappingProcessor.class);
    
    public OverlappingProcessor(Dataset ds, StatusMonitor sm) {
        super(ds, sm);
    }

    public OverlappingProcessor(Dataset ds) {
        super(ds);
    }

    /**
     * Allocate rows from the dataset to bins.  
     * 
     * @param chr
     * @param nBins
     * @param binSize
     * @return
     */
    protected List<Bin> allocateBins(String chr, int nBins, double binSize,
            int [] startLocations, int [] endLocations) {

        assert startLocations.length == endLocations.length;

        List<CollectionBin> allBins = new ArrayList(nBins);
        for (int i = 0; i < nBins; i++) {
            int location = (int) (i * binSize);
            allBins.add(new CollectionBin(location));
        }

        for (int i = 0; i < startLocations.length; i++) {
            int bStart = (int) (startLocations[i] / binSize);
            int end = (endLocations == null ? startLocations[i] + 1 : endLocations[i]);
            int bEnd = (int) (end / binSize);

            if (bStart < 0) {
                System.out.println("Negative bStart");
            }

            for (int b = bStart; b <= bEnd; b++) {
                if (b < allBins.size()) {
                    allBins.get(b).addIndex(i);
                } else {
                    //log.info("Feature location > chr length (" + b * binSize + ") " + chr);
                }
            }


        }


        // Remove empty bins.
        List<Bin> occupiedBins = new ArrayList(allBins.size());
        for (CollectionBin bin : allBins) {
            if (bin.getFeatureCount() > 0) {
                occupiedBins.add(bin);
            }
        }

        return occupiedBins;
    }

    /**
     * Return data for the specified bin.  All NaN values are removed.
     */
    protected float[] getDataForBin(float[] data, Bin bin) {

        CollectionBin cBin = (CollectionBin) bin;
        // Specifc  -> Get data for bin
        // Specifc  -> Get data for bin
        int nDataPts = 0;
        for (Integer i : cBin.getIndeces()) {
            if (!Float.isNaN(data[i])) {
                nDataPts++;
            }
        }

        if (nDataPts > 0) {
            float[] binData = new float[nDataPts];
            int binDataIndex = 0;
            for (Integer i : cBin.getIndeces()) {
                if (!Float.isNaN(data[i])) {
                    binData[binDataIndex] = data[i];
                    binDataIndex++;
                }
            }
            return binData;
        } else {
            return null;
        }
    }


}
