/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.LocusScore;

/**
 *
 * @author jrobinso
 */
public class FeatureBinCalculator {

     /**
     * Allocates features to FeatureBins.  FeatureBins are equally spaced and begin at startLocation.  
     * 
     * @param features
     * @param nFeatureBins
     * @param featureBinSize
     * @param startLocation
     * @param endLocation
     * @return
     */
    public List<FeatureBin> computeFeatureBins(List<? extends LocusScore> features, int nFeatureBins, double binSize, int startLocation, int endLocation) {

        TreeMap<Integer, FeatureBin> featureBins = new TreeMap();

        // Allocate features to FeatureBins
        for (LocusScore feature : features) {
            int binStart = (int) ((feature.getStart() - startLocation) / binSize);
            int binEnd = (int) ((feature.getEnd() - startLocation) / binSize);
            if (binEnd >= 0 && binStart < nFeatureBins) {
                int lastBin = Math.min(binEnd + 1, nFeatureBins);
                for (int b = Math.max(0, binStart); b < lastBin; b++) {
                    // We know this is a feature bin.  Ugly, but no time to redesign this
                    FeatureBin fBin =   featureBins.get(b);
                    if(fBin == null) {
                        int location = (int) (startLocation + b * binSize);
                        fBin = new FeatureBin(location);
                        featureBins.put(b, fBin);
                    }
                    fBin.addFeature(feature);
                }
            }
        }

        Collection c  = featureBins.values();
        return new ArrayList(featureBins.values());
    }



}
