/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * Bin.java
 *
 * Created on October 29, 2007, 3:40 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.LocusScore;

/**
 * Represents a tile bin.
 *   start -- start location of the bin
 *   features --  list of features that partially or fully overlap the bin
 * 
 * // TODO = this is a mix of two types, a feature type bin and snp type bin.  
 * //        the feature bin uses the "features" collection, snp type uses
 *           startIndex / endIndex.
 * //        refactor to combine both or split.
 * @author jrobinso
 */
public class FeatureBin implements Bin {

    private int start;
    private List<LocusScore> features;

    public FeatureBin(int location) {
        this.start = location;
        features = new ArrayList();
    }
    
    public void addFeature(LocusScore feature) {
        features.add(feature);
    }

    public List<LocusScore> getFeatures() {
        return features;
    }

    public int getFeatureCount() {

        return getFeatures().size();

    }

    /**
     * Return the scores for this bin after removing all NaN values.  If
     * there are no scores return null;
     * @return
     */
    public float[] getFeatureScores() {

        int nScores = 0;
        for (LocusScore f : features) {
            if (!Float.isNaN(f.getScore())) {
                nScores++;
            }
        }

        if (nScores > 0) {
            float[] scores = new float[nScores];
            int scoreIndex = 0;
            for (LocusScore f : features) {
                float s = f.getScore();
                if (!Float.isNaN(s)) {
                    scores[scoreIndex] = s;
                    scoreIndex++;
                }
            }
            return scores;
        } else {
            return null;
        }
    }

    public int getStart() {
        return start;
    }
}

