/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * Represents the complete group of data files defining a single chromosome.
 *
 * @author jrobinso
 *
 */
class ChromosomeFileGroup {

    enum LocationType {LONG, INT};
    
    LocationType locationType = LocationType.LONG;
    private File locationFile;
    private File markerIdFile;
    
    public ChromosomeFileGroup(LocationType type) {
        locationType = type;
    }
    
    /** Map of array name -> data file */
    private Map<String, File> dataFiles = new HashMap();

    public File getLocationFile() {
        return locationFile;
    }

    public void setLocationFile(File locationFile) {
        this.locationFile = locationFile;
    }

    public File getMarkerIdFile() {
        return markerIdFile;
    }

    public void setMarkerIdFile(File markerIdFile) {
        this.markerIdFile = markerIdFile;
    }

    public void addDataFile(String array, File dataFile) {
        dataFiles.put(array, dataFile);
    }

    public File getDataFile(String array) {
        return dataFiles.get(array);
    }

    /**
     * Assumes all data files are equal length (they have to be), and
     * are of type float (again, they have to be).
     */
    public long getDataLength() {
        if (dataFiles.isEmpty()) {
            return 0;
        }
        File anyDataFile = dataFiles.values().iterator().next();
        return anyDataFile.length() / 4;
    }

    public Collection<String> getArrayNames() {
        return dataFiles.keySet();
    }
    
    public boolean validate() {
        
        if(locationFile == null) {
            System.err.println("Missing location file");
            return false;
        }
        if(dataFiles == null || dataFiles.isEmpty()) {
            System.err.println("No data files for " + locationFile.getName());
            return false;
        }
        else if (!locationFile.exists()) {
            System.err.println("Location file: " + locationFile.getAbsolutePath() + " does not exist.");
            return false;
        }
        else {
            long fSize = locationFile.length();
            int nLocPoints = (locationType == LocationType.LONG ? 
                (int) (fSize / 8) : (int) (fSize / 4));
            for(File dataFile : dataFiles.values()) {
                if(!dataFile.exists()) {
                    System.err.println("Data file: " + dataFile.getAbsolutePath() + " does not exist.");
                    return false;
                }
                int nDataPts = (int) (dataFile.length() / 4);
                if(nDataPts != nLocPoints) {
                    System.err.println("Unexpected file size for file: " + dataFile.getName() + "  expected " +
                            nLocPoints * 4 + " size = " + dataFile.length());
                    return false;
                }
            }        
        }
        return true;
    }
}
