/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.preprocess.old;

import java.util.Iterator;

/**
 *
 * @author jrobinso
 */
public class BinIndexList implements Iterable {
    private int startIndex;
    private int endIndex;

    public int getStartIndex() {
        return startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
    
    public Iterator<Integer> iterator() {
        return new BinIndexIterator<Integer>();
    }
    
    class BinIndexIterator<T> implements Iterator {

        int nextIndex;
        
        public BinIndexIterator() {
            nextIndex = startIndex;
            
        }

        public boolean hasNext() {
            return nextIndex < endIndex;
        }

        public T next() {
            Integer retValue =  new Integer(nextIndex);
            nextIndex++;
            return (T) retValue;
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        
    }
    
    public static void main(String [] args) {
  
        BinIndexList bil = new BinIndexList();
        bil.setStartIndex(1);
        bil.setEndIndex(10);
        for(Object i : bil) {
            System.out.println(i);
        }
    }



}
