/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



package org.broad.igv.preprocess.old;

//~--- non-JDK imports --------------------------------------------------------

import java.io.BufferedReader;
import org.broad.igv.data.ExpressionProbe;

import org.broad.igv.data.ProbeSet;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.GeneManager;
import org.broad.igv.ui.MiscStuff;

//~--- JDK imports ------------------------------------------------------------

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import java.util.List;
import org.broad.igv.feature.UCSCGeneTableParser;
import org.broad.igv.util.AsciiLineReader;

/**
 * Utlity to create a probe list from an affy annotation file
 *
 * @author jrobinso
 */
public class AffyProbeListUtilities {

    static String genome = "hg18";
    static File annotFile =
        new File("../../gp/SnpViewer/data/jamboree/HT_HG-U133A.na23.annot.csv");

    /**
     * Method description
     *
     *
     * @param args
     *
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        String gctFile =
            "/Users/jrobinso/IGVTestData/PrimaryGBMs.43.use_for_outlier_analysis.centered_and_normalized.gct";
        addGenesToGctFile(gctFile);
    }

    /**
     * Method description
     *
     *
     * @param gctFile
     *
     * @throws IOException
     */
    public static void addGenesToGctFile(String gctFile) throws IOException {

        File outputFile = new File("fixed.gct");
        GeneManager geneData = new GeneManager(genome, "Gene");
        String refGeneFile = genome + "_refFlat.txt";
        InputStream is2 = MiscStuff.class.getResourceAsStream("/resources/"
                              + refGeneFile);
        AsciiLineReader reader2 = new AsciiLineReader(is2);
        List<Feature> genes = (new UCSCGeneTableParser(UCSCGeneTableParser.Type.REFFLAT)).loadFeatures(reader2);
        for (Feature gene : genes)
        {
            geneData.addGene(gene);
        }
        geneData.sortGeneLists();
        reader2.close();

        ProbeSet pset = AffyAnnotationParser.parseFile(annotFile, geneData);

        reader2 = new AsciiLineReader(new FileInputStream(gctFile));
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));

        String nextLine = reader2.readLine();    // header, skip
        reader2.readLine();
        reader2.readLine();

        int noMatch = 0;
        while ((nextLine = reader2.readLine()) != null)
        {
            String[] tokens = nextLine.split("\t");
            if (tokens.length < 2)
            {
                pw.println(nextLine);

            }
            else
            {
                String probeId = tokens[0].trim();
                String desc = tokens[1].trim();
                ExpressionProbe probe = pset.getProbe(probeId);
                if (probe == null)
                {
                    noMatch++;
                    pw.println(nextLine);
                }
                else
                {
                    pw.print(probeId + "\t");
                    pw.print(desc);
                    pw.print(" |@" + probe.getFeature() + "|");

                    for (int i = 2; i < tokens.length; i++)
                    {
                        pw.print("\t" + tokens[i]);
                    }
                    pw.println();
                }
            }
        }

        pw.close();
        reader2.close();

        System.out.println("# rows not matched = " + noMatch);
    }

    /**
     * Method description
     *
     *
     * @throws IOException
     */
    public static void createProbeMappingFile() throws IOException {

        File outputFile = new File("probes.hg18.tab");
        GeneManager geneData = new GeneManager(genome, "Gene");
        String refGeneFile = genome + "_refFlat.txt";
        InputStream is2 = MiscStuff.class.getResourceAsStream("/resources/"
                              + refGeneFile);
        AsciiLineReader reader2 = new AsciiLineReader(is2);
        List<Feature> genes = (new UCSCGeneTableParser(UCSCGeneTableParser.Type.REFFLAT)).loadFeatures(reader2);
        for (Feature gene : genes)
        {
            geneData.addGene(gene);
        }
        geneData.sortGeneLists();
        reader2.close();

        ProbeSet pset = AffyAnnotationParser.parseFile(annotFile, geneData);

        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        for (String chr : pset.getChromosomes())
        {
            for (ExpressionProbe ep : pset.getProbes(chr))
            {
                pw.println(ep.getName() + "\t" + ep.getChr() + "\t"
                           + ep.getStart() + "\t" + ep.getEnd());
            }
        }
        pw.close();
    }

    /**
     * Method description
     *
     *
     * @throws IOException
     */
    public static void createGeneMappingFile() throws IOException {

        File outputFile = new File("genes.hg18.tab");
        GeneManager geneData = new GeneManager(genome, "Gene");
        String refGeneFile = genome + "_refFlat.txt";
        InputStream is2 = MiscStuff.class.getResourceAsStream("/resources/"
                              + refGeneFile);
        AsciiLineReader reader2 = new AsciiLineReader(is2);
        List<Feature> genes = (new UCSCGeneTableParser(UCSCGeneTableParser.Type.REFFLAT)).loadFeatures(reader2);
        for (Feature gene : genes)
        {
            geneData.addGene(gene);
        }
        geneData.sortGeneLists();
        reader2.close();

        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        for (String chr : geneData.getChromosomes())
        {
            for (Feature gene : geneData.getGenesForChromosome(chr))
            {
                pw.println(gene.getName() + "\t" + chr + "\t" + gene.getStart()
                           + "\t" + gene.getEnd());
            }
        }

        pw.close();
    }
}
