/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * AffyAnnotationParser.java
 *
 * Created on October 31, 2007, 8:30 AM
 *
 * Parse an affy probe annotation csv file
 */
package org.broad.igv.preprocess.old;

import org.broad.igv.data.ExpressionProbe;
import org.broad.igv.data.ProbeSet;
import org.broad.igv.feature.GeneManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.ParsingUtils;

/**
 *
 * @author jrobinso
 */
public class AffyAnnotationParser {

    /**
     * Parse the probe annotation file and return a list of ExpressionProbes.  If
     * geneData is not null the probes will include gene info and be sorted by
     * chromosome.
     */
    public static ProbeSet parseFile(File probeFile, GeneManager geneData) {

        if (geneData == null) {
            System.out.println("null geneData");
            return null;
        }
        ProbeSet probeList = new ProbeSet();


        try {
            int nLine = 0;
            
            PrintWriter pw = new PrintWriter(new FileWriter("Unmatched.tab"));
            
            BufferedReader reader = new BufferedReader(new FileReader(probeFile));
            String nextLine = reader.readLine();
            while ((nextLine = reader.readLine()) != null) {
                nLine++;
                String[] tokens = nextLine.split("\",\"");
                if (tokens.length > 14) {
                    
                    String probeId = tokens[0].replace('\"', ' ').trim().toLowerCase();
                    String geneId = ParsingUtils.convertChrString(tokens[14].replace('\"', ' ').trim());

                    ExpressionProbe probe = new ExpressionProbe(probeId, geneId);
                    Feature gene = FeatureDB.getFeature(geneId);

                    // Not interested in probes without gene mappings
                    if (gene != null) {
                        probe.setChr(gene.getChromosome());
                        probe.setStart((int) gene.getStart());
                        probe.setEnd((int) gene.getEnd());
                        probeList.add(probe);

                    }
                    else {
                        pw.println(probe +"\t" + gene);
                    }
                }
            }
            System.out.println("#lines = " + nLine);
            reader.close();
            pw.close();



        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }

        return probeList;
    }
}




