/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.preprocess;

import java.util.List;
import org.broad.igv.feature.Genome;
import org.broad.igv.track.WindowFunction;

/**
 *  mean only for now
 * @author jrobinso
 */
public class Preprocessor implements DataConsumer {

    int nTracks;
    Genome genome;
    WindowFunction [] windowFunctions;

    public void addData(String chr, int start, int end, float data) {
       System.out.println("Add data: " + chr + ":" + start + "-" + end + "\t" + data);
    }


    public void newChromosome(String chr) {
        System.out.println("New chromosome: " + chr);
    }

    public void parsingComplete() {
        
    }


    class ChrGroup {
        
        String chr;
        List<ZoomLevel> zoomLevels;

        void addData(int start, int end, float [] data) {

        }

    }
    
    class ZoomLevel {
        float tileWidth;

        void addData(int start, int end, float [] data) {
            int startTile = (int) (start / tileWidth);
            int endTile = (int) (end / tileWidth);
        }

    }

    class Tile {
        int tileStart;
        float binWidth;
        int nBins;
        Accumulator [] accumulators;   // <= 1 per bin.  Where does sample info fit ? 

        void addData(int start, int end, float [] data) {
            
            int startBin = Math.max(0, (int) ((start - tileStart) / binWidth));
            int endBin = Math.min(nBins - 1, (int) ((end - tileStart) / binWidth));
            for(int b = startBin; b <= endBin; b++) {
                
            }

        }
    }

    // An accumulator for each bin.  A tile will hav nBin accumulators.
    static class AccumulatorSet {

        Accumulator [] accumulators;

        AccumulatorSet(int n) {
            accumulators = new Accumulator[10];
        }

        void allocationData(float [] data) {

            assert(data.length == accumulators.length);

            for(int i=0; i<data.length; i++) {
                accumulators[i].add(data[i]);
            }
        }
    }

    public static void main(String [] args) {
        String fn = "/Users/jrobinso/IGV/TestData/pten_egfr_varystep.wig";
        WiggleParser wg = new WiggleParser(fn);
        wg.setDataConsumer(new Preprocessor());
        wg.parse();
    }
}
