/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.track.WindowFunction;

/**
 *
 * @author jrobinso
 */
public class Accumulator {

    /*
     *         DoubleArrayList percentiles = new DoubleArrayList(3);

    percentiles.add(0.1);
    percentiles.add(0.5);
    percentiles.add(0.96);

    DoubleQuantileFinder qf = QuantileFinderFactory.newDoubleQuantileFinder(false,
    Long.MAX_VALUE, 0.0010, 1.0E-4, percentiles.size(), null);

    for (Bin bin : bins)
    {
    int count = bin.getFeatureCount();

    mean += count;
    max = Math.max(max, count);
    qf.add(count);
    }

    binInfo.setMeanCount(mean / bins.size());
    binInfo.setMaxCount(max);

    DoubleArrayList quantiles = qf.quantileElements(percentiles);

    binInfo.setPercentile10(quantiles.get(0));
    binInfo.setMedianCount(quantiles.get(1));
    binInfo.setPercentile90(quantiles.get(2));
     */
    DoubleQuantileFinder qf;
    Map<WindowFunction, Float> values;
    WindowFunction[] windowFunctions;
    List<WindowFunction> quantileFunctions;
    float min = Float.MAX_VALUE;
    float max = Float.MIN_VALUE;
    float sum = 0.0f;
    int nPts = 0;

    public Accumulator(WindowFunction[] windowFunctions) {
        this.windowFunctions = windowFunctions;
        findPercentileFunctions();
        if (!quantileFunctions.isEmpty()) {
            qf = QuantileFinderFactory.newDoubleQuantileFinder(false,
                    Long.MAX_VALUE, 0.0010, 1.0E-4, quantileFunctions.size(), null);
        }
    }

    public void add(float v) {
        min = Math.min(min, v);
        max = Math.max(max, v);
        sum += v;
        nPts++;

        if(qf != null) {
            qf.add(v);
        }
    }

    private void findPercentileFunctions() {
        quantileFunctions = new ArrayList();
        for (WindowFunction wf : windowFunctions) {
            if (wf == WindowFunction.percentile10 || wf == WindowFunction.median ||
                    wf == WindowFunction.percentile90) {
                quantileFunctions.add(wf);
            }
        }
    }

    public double convertQuantileFunction(WindowFunction wf) {
        switch (wf) {
            case percentile10:
                return 0.1;
            case percentile90:
                return 0.9;
            case median:
                return 0.5;
            default:
                return -1.0;
        }
    }

    public void finish() {
        values = new HashMap(windowFunctions.length);
        if (!quantileFunctions.isEmpty()) {
            DoubleArrayList percentiles = new DoubleArrayList(quantileFunctions.size());
            for (WindowFunction wf : quantileFunctions) {
                percentiles.add(convertQuantileFunction(wf));
            }
            DoubleArrayList quantiles = qf.quantileElements(percentiles);
            for (int i = 0; i < quantileFunctions.size(); i++) {
                values.put(quantileFunctions.get(i), (float) quantiles.get(i));
            }
        }
        values.put(WindowFunction.min, min);
        values.put(WindowFunction.max, max);
        values.put(WindowFunction.mean, sum / nPts);
        values.put(WindowFunction.count, (float) nPts);

    }

    public float getValue(WindowFunction wf) {
        if (values == null) {
            throw new java.lang.IllegalStateException(
                    "Accumulator is still open.  Call finish() before getValue()");
        }
        return values.get(wf);
    }
}
