/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.main;

import java.net.*;
import java.io.*;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGVMainFrame;

public class CommandListener implements Runnable {

    private static Logger log = Logger.getLogger(CommandListener.class);
    public static int port = 60151;

    public static void main(String[] args) throws IOException {
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            log.info("Listening on port " + port);

            while (true) {
                Socket clientSocket = null;
                try {
                    System.out.println("Listening on port: " + port);
                    clientSocket = serverSocket.accept();

                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(
                            new InputStreamReader(
                            clientSocket.getInputStream()));
                    String inputLine;

                    while ((inputLine = in.readLine()) != null) {
                        parseCommand(inputLine);
                    }
                    out.close();
                    in.close();
                    clientSocket.close();
                } catch (IOException e) {
                    log.error("Accept failed.", e);
                } finally {
                    clientSocket.close();
                }

            }

        } catch (IOException e) {
            log.error("Could not listen on port: " + port, e);
        } finally {
            try {
                serverSocket.close();
            } catch (IOException ex) {
                log.error("Error closing command listener socket", ex);
            }
        }
    }

    private void parseCommand(String command) {
        String[] tokens = command.split(" ");
        if (tokens.length > 1) {
            String cmd = tokens[0];
            if (cmd.equals("echo")) {
                System.out.println(command);
            } else if (cmd.equals("openSession") && tokens.length > 1) {
                try {
                    URL sessionURL = new URL(tokens[1]);
                    String locus = tokens.length > 2 ? tokens[2] : null;
                    IGVMainFrame.getInstance().doRestoreSession(sessionURL, cmd);
                } catch (MalformedURLException e) {
                    log.error("Error restoring session", e);
                }
            }
        }
    }
}
