/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf.conservation;

import java.awt.Rectangle;
import org.broad.igv.data.DataSource;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.RenderContext;

/**
 *
 * @author jrobinso
 */
public class OmegaTrack extends DataSourceTrack {

    public OmegaTrack(ResourceLocator locator, String name, DataSource ds) {
        super(locator, name, ds);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        double locScale = context.getScale();

        if (locScale > 100000) {
            return;
        }

        super.render(context, rect);
    }
}
