/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf.conservation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.ParsingUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.AsciiLineReader;

/**
 *
 * @author jrobinso
 */
public class OmegaFileParser {

    public void getDataAsScores(File f, List<LocusScore> scores) {


        AsciiLineReader reader = null;
        try
        {
            String[] buffer = new String[5];
            reader = new AsciiLineReader(new FileInputStream(f));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null)
            {
                ParsingUtils.split(nextLine, buffer, '\t');
                int position = Integer.parseInt(buffer[0]) + 6;
                float score = Float.parseFloat(buffer[4]);
                scores.add(new OmegaScore(position, score));
            }

        } catch (IOException ex)
        {
            throw new RuntimeException("Error parsing file: " + f.getAbsolutePath(), ex);

        } finally
        {
            if (reader != null)
            {
                reader.close();
            }
        }
    }

    public void getDataAsArrays(File f, int[] locations, float[] data, int offset, int start, int end) {

        AsciiLineReader reader = null;
        try
        {
            String[] buffer = new String[5];
            reader = new AsciiLineReader(new FileInputStream(f));
            String nextLine = null;
            int idx = offset;
            while ((nextLine = reader.readLine()) != null)
            {
                ParsingUtils.split(nextLine, buffer, '\t');
                int s = Integer.parseInt(buffer[0]) + 6;
                if (s >= start)
                {
                    locations[idx] = s;
                    data[idx] = Float.parseFloat(buffer[4]);
                } else if (s > end)
                {
                    return;
                }
            }

        } catch (IOException ex)
        {
            throw new RuntimeException("Error parsing file: " + f.getAbsolutePath(), ex);

        } finally
        {
            if (reader != null)
            {
                reader.close();
            }
        }
    }

    public static class OmegaScore implements LocusScore {

        int position;
        float score;

        public OmegaScore(int position, float score) {
            this.position = position;
            this.score = score;
        }

        public int getStart() {
            return position;
        }

        public void setStart(int start) {
            throw new UnsupportedOperationException("setStart is not supported.");
        }

        public int getEnd() {
            return position + 1;
        }

        public void setEnd(int end) {
            throw new UnsupportedOperationException("setEnd is not supported");
        }

        public float getScore() {
            return score;
        }

        public void setConfidence(float confidence) {
            throw new UnsupportedOperationException("setConfidence is not supported yet.");
        }

        public float getConfidence() {
            return 1.0f;
        }

        public LocusScore copy() {
            return new OmegaScore(position, score);
        }

        public String getValueString(double position, WindowFunction windowFunction) {
            return String.valueOf("Omega score = " + score);
        }
    }
}
