/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf.conservation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.util.LRUCache;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

/**
 *
 * @author jrobinso
 */
public class OmegaDataSource extends AbstractDataSource implements DataSource {

    File rootDir = new File("/Volumes/igv/annotations/hg18/conservation/omega/12mer");

    public double getDataMax(String chr) {
        return 1;
    }

    public double getDataMin(String chr) {
        return 0;
    }

    /**
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation,
    int zoom) {

    if((endLocation - startLocation) > 1999000) {
    return new ArrayList();
    }
    String fn1 = getFileNameForPosition(chr, startLocation);
    String fn2 = getFileNameForPosition(chr, endLocation);

    int sz = (fn1.equals(fn2) ? 1000000 : 2000000);
    List<LocusScore> scores = new ArrayList(sz);

    File chrDir = new File(rootDir, chr.substring(3));

    OmegaFileParser parser = new OmegaFileParser();
    parser.parse(new File(chrDir, fn1), scores);
    if(!fn1.equals(fn2)) {
    parser.parse(new File(fn2), scores);
    }

    return scores;
    }
     */
    public TrackType getTrackType() {
        return TrackType.OTHER;
    }

    public void setWindowFunction(WindowFunction statType) {
        // ignored for now
    }

    public boolean isLogNormalized() {
        return false;
    }

    public void refreshData(long timestamp) {
        // ignore
    }

    public WindowFunction getWindowFunction() {
        return null;
    }

    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList();
    }

    public String getFileNameForPosition(String chr, int pos) {
        //chr1_2000000-2999999.omega
        int mb = (pos / 1000000) * 1000000;
        int end = mb + 999999;
        return chr + "_" + mb + "-" + end + ".omega";
    }

    @Override
    protected int getNumZoomLevels(String chr) {
        return 0;
    }


    LRUCache<String, DataTile> tileCache = new LRUCache(3);

    @Override
    public DataTile getRawData(String chr, int startLocation, int endLocation) {

        // harcode to egfr
         startLocation = 55240000;
         endLocation =   55242525;

        int bStart = startLocation / 1000000;
        int bEnd = endLocation / 1000000;

        String key = chr + bStart + "_" + bEnd;
        if(tileCache.containsKey(key)) {
            return tileCache.get(key);
        }

        File chrDir = new File(rootDir, chr.substring(3));
        List<File> files = new ArrayList(bEnd - bStart + 1);
        for (int i = bStart; i <= bEnd; i++) {

            int start = i * 1000000;
            int end = start + 999999;
            File f = new File(chrDir, chr + "_" + start + "-" + end + ".omega");
            if (f.exists()) {
                files.add(f);
            }

        }

        if(files.isEmpty()) {
            return null;
        }

        int sz = endLocation - startLocation;
        int[] starts = new int[sz];
        float[] data = new float[sz];

        OmegaFileParser parser = new OmegaFileParser();

        int offset = 0;
        for (File f : files) {
            parser.getDataAsArrays(f, starts, data, offset, startLocation, endLocation);
            offset += 1000000;
        }
        DataTile dt = new DataTile(starts, null, data, null);
        tileCache.put(key, dt);
        return dt;

    }

    @Override
    public double getMedian(int zoom, String chr) {
        return 1;
    }

    /*
     *         private int[] startLocations;
    private int[] endLocations;
    private float[] values;

    public DataTile(int [] startLocations, int [] endLocations, float [] values) {
    this.startLocations = startLocations;
    this.endLocations = endLocations;
    this.values = values;
    }
     */
}
