/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.maf.MAFTile.MASequence;

/**
 *
 * @author jrobinso
 */
public class MAFTileCodec {

    /**
     * Serialize an MATile to a stream
     * 
     */
    public void encode(MAFTile maTile, DataOutputStream os) {

        try {
            os.writeInt(maTile.start);
            os.writeInt(maTile.end);
            os.writeInt(maTile.alignedSequences.size());
            for (Map.Entry<String, MASequence> entry : maTile.alignedSequences.entrySet()) {
                os.writeUTF(entry.getKey());
                os.writeUTF(entry.getValue().bases);
            }

            os.writeInt(maTile.gapAdjustedIdx.length);
            for (int i = 0; i < maTile.gapAdjustedIdx.length; i++) {
                os.writeInt(maTile.gapAdjustedIdx[i]);
            }
            os.flush();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MAFTile decode(java.io.DataInputStream inputStream) {

        try {

            int start = inputStream.readInt();
            int end = inputStream.readInt();
            int sz = inputStream.readInt();
            if(sz == 0) {
                return new MAFTile(start, end);
            }
            Map<String,String> bases = new HashMap(sz);
            for (int i=0; i<sz; i++) {
                String speciesId = inputStream.readUTF();
                String b = inputStream.readUTF();
                bases.put(speciesId, b);
             //   tile.alignedSequences.put(speciesId, new MASequence(tile, bases));
            }

            sz = inputStream.readInt();
            int[] gapAdjustedCoordinates = new int[sz];
            for (int i = 0; i < sz; i++) {
                gapAdjustedCoordinates[i] = inputStream.readInt();
            }
            return new MAFTile(start, end, bases, gapAdjustedCoordinates);

        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

}
