/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.maf;

//~--- non-JDK imports --------------------------------------------------------
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment.AlignedSequence;

//~--- JDK imports ------------------------------------------------------------

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class MAFTile {

    int start;
    int end;
    MASequence refSeq;
    int[] gapAdjustedIdx;
    List<Gap> gaps = new ArrayList();
    /** Map of species id -> aligned sequence */
    Map<String, MASequence> alignedSequences;

    public MAFTile() {
    }

    // Constructor for an empty maf tile (no alignments)
    public MAFTile(int start, int end) {
        this.start = start;
        this.end = end;
        this.alignedSequences = null;
        this.gapAdjustedIdx = null;

    }

    public MAFTile(int start, int end, Map<String, String> bases, int[] gapAdjustedCoordinates) {
        this(start, end, bases, gapAdjustedCoordinates, "hg18");
    }

    public MAFTile(int start, int end, Map<String, String> bases, int[] gapAdjustedCoordinates, String refSeqId) {
        this.start = start;
        this.end = end;

        this.gapAdjustedIdx = gapAdjustedCoordinates;

        int expectedGapAdjustedIdx = 0;
        for (int i = start; i < end; i++) {
            int idx = i - start;
            int gapAdjIdx = gapAdjustedIdx[idx];
            if (gapAdjIdx != (expectedGapAdjustedIdx)) {
                gaps.add(new Gap(i, expectedGapAdjustedIdx, gapAdjIdx));
            }
            expectedGapAdjustedIdx = gapAdjIdx + 1;
        }


        refSeq = new MASequence(bases.get(refSeqId));
        //assert ((refSeq != null) && (refSeq.length() > 0));
        //computeCoordinates();

        this.alignedSequences = new LinkedHashMap();
        for (Map.Entry<String, String> entry : bases.entrySet()) {
            String spId = entry.getKey();
            String b = entry.getValue();
            alignedSequences.put(spId, new MASequence(b));
        }
    }

    /**
     * @return the gaps
     */
    public List<Gap> getGaps() {
        return gaps;
    }

    /**
     * Class description
     *
     *
     * @version    Enter version here..., 09/01/22
     * @author     Enter your name here...
     */
    public static class Gap {

        int position;
        int startIdx;
        int endIdx;

        /**
         * Constructs ...
         *
         *
         * @param position
         * @param startIdx
         */
        public Gap(int position, int startIdx, int endIdx) {
            this.position = position;
            this.startIdx = startIdx;
            this.endIdx = endIdx;
        }

        public int getPosition() {
            return position;
        }

        /**
         * Method description
         *
         *
         * @return
         */
        public int getCount() {
            return endIdx - startIdx;
        }

        /**
         * Method description
         *
         *
         * @return
         */
        public String toString() {
            return position + "(" + (endIdx - startIdx + 1) + ")";
        }
    }

    public class MASequence {

        String bases;

        public MASequence(String bases) {
            this.bases = bases;
        }

        public char getGapAdjustedBase(int refCoord) {

            int relCoord = refCoord - start;
            int idx = gapAdjustedIdx[relCoord];
            return (idx > 0 && idx < bases.length()) ? bases.charAt(idx) : (char) 0;
        }

        public int getStart() {
            return start;
        }

        public int getEnd() {
            return end;
        }
    }
}
