/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.util.ResourceLocator;

/**
 *
 * @author jrobinso
 */
public class MAFRemoteReader implements MAFReader {

    static Logger log = Logger.getLogger(MAFRemoteReader.class);
//    String serverURL = "http://localhost:8080/webservices/igv";
    String serverURL = "http://www.broadinstitute.org/webservices/igv";
    static MAFTileCodec codec = new MAFTileCodec();

    // 
    public MAFRemoteReader(ResourceLocator locator) {
    // TODO -- set server URL and path to MAF directory
        
    }
    
    public MAFTile loadTile(String chr, int start, int end,
            List<String> species) {
        DataInputStream is = null;
        try {
            URL url = new URL(serverURL + "?method=maf&chr=" +
                    chr + "&start=" + start + "&end=" + end);
            URLConnection connection = url.openConnection();
            is = new DataInputStream(new GZIPInputStream(new BufferedInputStream(connection.getInputStream())));
            MAFTile tile = codec.decode(is);
            return tile;
        } catch (IOException ex) {
            log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        } finally {
            if (is != null) {
                try {
                    is.close();

                } catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }

        }
    }
}
