/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.maf;

import edu.mit.broad.prodinfo.genomicplot.ParseException;
import edu.mit.broad.prodinfo.multiplealignment.MAFAlignment;
import edu.mit.broad.prodinfo.multiplealignment.MAFIO;
import edu.mit.broad.prodinfo.multiplealignment.MultipleAlignment.AlignedSequence;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.log4j.Logger;

/**
 *
 * @author jrobinso
 */
public class MAFLocalReader implements MAFReader {

    private static Logger log = Logger.getLogger(MAFLocalReader.class);
    public static String mafFile;
    MAFIO mafIO;
    List<String> sequenceIds;

    public MAFLocalReader(String mafFileName) {
        mafFile = mafFileName;
        try {
            mafIO = new MAFIO(mafFile, false);
            MAFAlignment maf = mafIO.load(mafFile);
            sequenceIds = maf.getAlignedSequenceIds();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<String> getSequenceIds() {
        return sequenceIds;
    }

    public MAFTile loadTile(
            String seq,
            int start,
            int end,
            List<String> species) {
        try {

            MAFAlignment maf = mafIO.load(species, start, end);

            if(maf.isEmpty()) {
                return null;
            }
            
            AlignedSequence refSeq = maf.getAlignedSequences().get(0);

            // TODO -- compare refSeq with seq, if not equal => error

            int[] gapAdjustedCoordinates = new int[end - start];
            for (int i = start; i < end; i++) {
                int idx = i - start;
                gapAdjustedCoordinates[idx] = refSeq.getGapAdjustedCoordinate(
                        idx);
            }

            Map<String, String> bases = new HashMap();
            for (String seqId : maf.getAlignedSequenceIds()) {
                bases.put(seqId,
                        maf.getAlignedSequence(seqId).getSequenceBases());
            }


            return new MAFTile(start, end, bases, gapAdjustedCoordinates, refSeq.getId());

        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        mafIO.destroyFileHandle();
    }
}
