/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ibf;

/**
 *
 * @author jrobinso
 */
public class IBFFixedTile implements IBFBin {

    int nColumns;
    float span;
    int start;
    float [] data;

    public IBFFixedTile(int nColumns, int start, float span, float [] data) {
        this.nColumns = nColumns;
        this.span = span;
        this.data = data;
        this.start = start;
    }

    public int getSize() {
        return nColumns;
    }

    public int getStartPosition(int idx) {
        return start + (int) (idx * span);
    }

    public int getEndPosition(int idx) {
        return (int) ((idx + 1) * span);
    }

    public float getValue(int row, int idx) {
        return data[row * nColumns + idx];
    }

}
