/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ibf;

import java.util.Arrays;

/**
 * Specific dataset implementation for fixed step format (e.g. wig).  To be
 * generalized later.
 * @author jrobinso
 */
public class IBFDataset {

    enum DataType {

        BYTE, SHORT, INT, FLOAT, DOUBLE, STRING
    };

    String name;
    DataType dataType;
    float tileWidth;
    float binWidth;
    long[] tilePositions;

    public IBFDataset(String name, DataType dataType, float tileWidth, float binWidth,
            int nTiles) {
        this.name = name;
        this.dataType = dataType;
        this.tileWidth = tileWidth;
        this.binWidth = binWidth;
        this.tilePositions = new long[nTiles];
        // Initialize tile positions to -1.  This indicates a blank tile and is the default
        Arrays.fill(tilePositions, -1);
    }
}
