/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.h5;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 *
 * @author jrobinso
 */
public class ZipWriter extends ZipBase implements HDFWriter {

    int fileId;
    String fileName;
    ZipOutputStream zos = null;
    Map<String, String> attributes = new HashMap();

    public ZipWriter() {
    }

    public int createFile(String name) {

        try {

            fileId = name.hashCode();
            addEntity(fileId, "/");
            this.fileName = name;
            zos = new ZipOutputStream(new FileOutputStream(fileName));

            return fileId;
        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private int createEntity(int locId, String name) {
        String fullName = getFullName(locId, name);
        int id = fullName.hashCode();
        addEntity(id, fullName);
        return id;
    }

    public void closeDataset(int datasetId) {
        // No op
    }

    public void closeFile(int fileId) {
        String entryName = "attributes";
        this.writeMap(entryName, attributes);
        try {
            zos.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }

    public void closeGroup(int groupId) {
    }

    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray) {
        String fullName = getFullName(locId, dsName);
        this.writeStrings(fullName, stringArray);
    }

    public void createAndWriteStringDataset(int locId, String dsName, String[] stringArray,
            int stringSize) {
        createAndWriteStringDataset(locId, dsName, stringArray);
    }

    public int createDataset(int locId, String name, int typeId, long[] dims) {
        return createEntity(locId, name);
    }

    public int createGroup(int locId, String name) {
        return createEntity(locId, name);
    }

    public int openDataset(int fileId, String dsName) {
        return openEntity(fileId, dsName);
    }

    public int openGroup(int locId, String name) {
        return openEntity(locId, name);
    }

    private int openEntity(int locId, String name) {
        // If name starts with "/" it is absolute
        String fullName = (name.startsWith("/") ? name : getFullName(locId, name));
        return getEntityId(fullName);

    }

    public int writeAttribute(int locId, String name, Object value) {
        String entityName = getEntityName(locId);
        String attributeName = entityName + "|" + name;
        attributes.put(attributeName, value.toString());
        return 1;
    }

    // Ignoring rowNumber for this test.  This will only work for single track data
    public void writeDataValue(int datasetId, int rowNumber, float value) {
        String dsName = getEntityName(datasetId);
        createAndWriteFloatDataset(dsName, new float[]{value});
    }

    private void writeMap(String entryName, Map<String, String> map) {
        try {
            // Put strings in a byte buffer.  We need to know the total size in bytes
            StringBuffer buff = new StringBuffer();
            for (Map.Entry<String, String> kv : map.entrySet()) {
                buff.append(kv.getKey() + "\t" + kv.getValue());
                buff.append('\n');
            }
            byte[] bytes = buff.toString().getBytes();

            createZipEntry(entryName, bytes);

        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
        }
    }

    private void writeStrings(String entryName, String[] strings) {
        try {
            // Put strings in a byte buffer.  We need to know the total size in bytes
            StringBuffer buff = new StringBuffer();
            for (String s : strings) {
                buff.append(s);
                buff.append('\n');
            }
            byte[] bytes = buff.toString().getBytes();

            createZipEntry(entryName, bytes);

        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
        }
    }

    // Ignoring rowId for this test.  This will only work for single track data
    public void writeDataRow(int datasetId, int rowId, float [] data, int length) {
        String dsName = getEntityName(datasetId);

            createAndWriteFloatDataset(dsName, (float[]) data);


    }

    /**
     * TODO -- temporary implementation to maintain interface.  Redo with 
     * overloaded methods.
     * @param locId
     * @param fullName
     * @param data
     */
    public void createAndWriteVectorDataset(int locId, String dsName, Object data) {
        String fullName = getFullName(locId, dsName);
        if (data instanceof int[]) {
            createAndWriteIntDataset(fullName, (int[]) data);
        } else if (data instanceof float[]) {
            createAndWriteFloatDataset(fullName, (float[]) data);
        } else {
            throw new RuntimeException("Unsupported type: " + data.getClass());
        }


    }

    private void createAndWriteIntDataset(String entryName, int[] data) {
        try {


            ByteArrayOutputStream bytes = new ByteArrayOutputStream(data.length * 4);
            DataOutputStream bos = new DataOutputStream(bytes);
            for (int i = 0; i < data.length; i++) {
                bos.writeInt(data[i]);
            }
            bos.close();
            byte[] byteArray = bytes.toByteArray();
            createZipEntry(entryName, byteArray);

        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createAndWriteFloatDataset(String entryName, float[] data) {
        try {

            ByteArrayOutputStream bytes = new ByteArrayOutputStream(data.length * 4);
            DataOutputStream bos = new DataOutputStream(bytes);
            for (int i = 0; i < data.length; i++) {
                bos.writeFloat(data[i]);
            }
            bos.close();
            byte[] byteArray = bytes.toByteArray();
            createZipEntry(entryName, byteArray);

        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createZipEntry(String entryName, byte[] bytes) throws IOException, IOException {
        ZipEntry anEntry = new ZipEntry(entryName);
        anEntry.setMethod(ZipEntry.STORED);
        anEntry.setCompressedSize(bytes.length);
        anEntry.setSize(bytes.length);

        anEntry.setCrc(getCrc(bytes));
        zos.putNextEntry(anEntry);

        BufferedOutputStream bos = new BufferedOutputStream(zos);
        bos.write(bytes);
        bos.flush();

        zos.closeEntry();
    }

    private long getCrc(byte[] buffer) throws IOException {
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(buffer, 0, buffer.length);
        return crc.getValue();

    }

    public void createAndWriteDataset(int nodeId, String dsName, float[][] data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
