/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.h5;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class ZipBase {

    private Map<String, Integer> entityIdMap = new HashMap();

    private Map<Integer, String> idEntityMap = new HashMap();

    protected String getFullName(int locId, String name) {
        
        // Names that start with / are absolute already
        if(name.startsWith("/")) {
            return name;
        }
        
        String entityName = idEntityMap.get(locId);
        if (!entityName.endsWith("/")) {
            entityName = entityName + "/";
        }
        String fullName = entityName + name;
        return fullName;
    }

    protected void addEntity(Integer id, String name) {
        idEntityMap.put(id, name);
        entityIdMap.put(name, id);

    }
    
    protected int getEntityId(String name) {
        return entityIdMap.get(name);
    }
    
    protected String getEntityName(int id) {
        return idEntityMap.get(id);
    }
    
    protected void removeEntity(int id) {
        String name = idEntityMap.get(id);
        idEntityMap.remove(id);
        entityIdMap.remove(name);
    }
}
