/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.h5;

import java.io.FileNotFoundException;

/**
 *
 * @author jrobinso
 */
public interface HDFWriter {

    /**
     * Close an hdf5 dataset
     */
    void closeDataset(int datasetId);

    /**
     * Close an hdf5 file
     */
    void closeFile(int fileId);

    /**
     * Close an hdf5 group
     */
    void closeGroup(int groupId);

    /**
     * Create a dataset of  strings.
     * // TODO -- look at H5DwriteString
     */
    void createAndWriteStringDataset(int locId, String dsName, String[] stringArray);

    /**
     * Create a dataset of fixed width strings
     * //TODO look at
     */
    void createAndWriteStringDataset(int locId, String dsName, String[] stringArray, int stringSize);

    public void createAndWriteDataset(int nodeId, String dsName, float[][] data);

    
    /**
     * Create a dataset, write the supplied data, and closeFile the dataset.
     * locId - parent object of the dataset, usually a group
     * dsName - name of the dataset
     * data - the data, either int[], long[], float[], double[], or String[].
     */
    void createAndWriteVectorDataset(int locId, String dsName, Object data);

    /**
     * Create a dataset in the group identifed by locId
     */
    int createDataset(int locId, String name, int typeId, long[] dims);

    int createFile(String name);

    /**
     * Create a group with the given name at the given location.
     * locId - the handle to a file or another group.  If locId refers to a file
     * name should be an absolute path.  If locId referst to a group
     * name should be relative to that group.
     * name - the name of the new group
     * @returns the identifier for the newly created group.
     */
    int createGroup(int locId, String name);

    int openDataset(int fileId, String dsName);

    int openGroup(int locId, String name);
    
    /**
     * Convenience function for writing a row of float data to an assumed 2-d
     * dataset.  
     * // TODO -- verification, check that dataset shape is 2-D, rowId and data.length are in bounds
     * @param datasetId
     * @param rowId
     * @param data
     */
    public void writeDataRow(int datasetId, int rowId, float [] data, int length);
    
    /**
     * Convenience function for writing a single float value to an assumed 1-d
     * dataset.  
     * // TODO -- verification, check that dataset shape is 1-D, cellId in bounds
     * @param datasetId
     * @param rowId
     * @param data
     */
    public void writeDataValue(int datasetId, int cellId, float value);
    

    /**
     * Write the attribute (string/value pair).  The method attempts to assign
     * the correct HDF5 typeId based on the runtime class of the value.  The rules
     * for typeId assignement are
     * Integer (int)     =>  H5T_NATIVE_INT
     * Long (long)       =>  H5T_NATIVE_LLONG
     * Float (float)     =>  H5T_NATIVE_FLOAT
     * All other numeric =>  H5T_NATIVE_DOUBLE
     * String            =>  H5T_C_S1
     */
    int writeAttribute(int locId, String name, Object value);

}
