/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and openFile the template in the editor.
 */
package org.broad.igv.h5;

import java.io.FileNotFoundException;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import org.apache.log4j.Logger;

/**
 * Class of examples to illustrate use of the HDF5LocalReader.  Also used for timing
 * tests.  
 */
public class HDFUtilsExamples {

    private static Logger log = Logger.getLogger(HDFUtilsExamples.class);

    private static HDF5LocalWriter writer = new HDF5LocalWriter();

    public static void main(String[] args) throws FileNotFoundException, HDF5LibraryException {
        //getDataHeaders();
        //testMatrix();
        //writeRows();
        //readRow();
        //writeStringDataset();
        //readStringDataset();
    }


    public static void writeStringDataset() {

        String[] strings = {"a", "variable", "length", "string", "array"};
        int fileId = writer.createFile("testStrings.h5");
        int groupId = writer.createGroup(fileId, "data");
        writer.writeAttribute(groupId, "attr", "value");
        writer.createAndWriteStringDataset(groupId, "testStrings", strings);
        writer.closeGroup(groupId);
        writer.closeFile(fileId);

    }

    public static void readStringDataset() {

        HDF5LocalReader reader = new HDF5LocalReader("testStrings.h5");
        int datasetId = reader.openDataset("/data/testStrings");
        int groupId = reader.openGroup("data");
        System.out.println(reader.readStringAttribute(groupId, "attr"));
        String[] strings = reader.readAllStrings(datasetId);
        for (int i = 0; i < strings.length; i++) {
            System.out.println(strings[i]);
        }

        reader.closeDataset(datasetId);
        reader.closeGroup(groupId);
        reader.closeFile();

    }

    public static void readRow() {


        int row = 5;
        int startCol = 10;
        int endCol = 710;

        HDF5LocalReader reader = new HDF5LocalReader("test.h5");
        String dsName = "/data/data_chr6_z5";

        long t0 = System.currentTimeMillis();
        int datasetId = reader.openDataset(dsName);
        long dt = System.currentTimeMillis() - t0;
        System.out.println("DS open time = " + dt);

        long t1 = System.currentTimeMillis();
        float[] floats = reader.readDataRowSlice(datasetId, row, startCol, endCol);
        dt = System.currentTimeMillis() - t1;
        System.out.println("dt = " + dt);

        reader.closeDataset(datasetId);
        reader.closeFile();


    }

    public static void readRow2() {

        int startCol = 10;
        int endCol = 710;

        //int fileId = reader.openFile("/Volumes/xchip_tcga/gbm/visualization/20071126_Demo_StagingArea/cn2.h5", reader.RDONLY);
        HDF5LocalReader reader = new HDF5LocalReader("cn2.h5");
        String dsName = "/data/chr1/z4/median";

        long t0 = System.currentTimeMillis();
        int datasetId = reader.openDataset(dsName);
        long dt = System.currentTimeMillis() - t0;
        System.out.println("DS open time = " + dt);

        long t1 = System.currentTimeMillis();
        float[][] floats = reader.readDataSlice(datasetId, startCol, endCol);
        dt = System.currentTimeMillis() - t1;
        System.out.println("dt = " + dt + "   # floats = " + (floats.length * floats[0].length));

        long t2 = System.currentTimeMillis();
        int dataSize = 0;
        for (int row = 0; row < 284; row++) {
            float[] floats2 = reader.readDataRowSlice(datasetId, row, startCol, endCol);
            dataSize += floats2.length;
        }
        dt = System.currentTimeMillis() - t2;
        System.out.println("dt = " + dt + "   # floats = " + dataSize);

        reader.closeDataset(datasetId);
        reader.closeFile();



    }
}
  
    

