/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.h5;

import java.io.File;
import org.broad.igv.util.ResourceLocator;

/**
 *
 * @author jrobinso
 */
public class HDF5ReaderFactory {

    /**
     * TODO this factory method will heck some property or argument to determine
     * whether to return a local or remote reader.   
     * 
     * @return
     */
    public static HDF5Reader getReader(ResourceLocator locator) {
        if (locator.isLocal()) {
            if (locator.getPath().endsWith(".h5")) {
                return new HDF5LocalReader(locator.getPath());
            } else {
                return new H5BinReader (new File(locator.getPath()));
            }
        } else {
            return new HDF5RemoteReader(locator);
        }
    }
}
