/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.h5;

import java.util.HashMap;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.exceptions.HDF5SymbolTableException;
import org.apache.log4j.Logger;

/**
 *
 * @author jrobinso
 */
public class HDF5EntityCache {

    private Logger log = Logger.getLogger(HDF5EntityCache.class);

    int fileId;

    Map<String, Integer> datasetCache;

    Map<String, Integer> groupCache;

    public HDF5EntityCache(int fileId) {
        this.fileId = fileId;
        datasetCache = new HashMap();
        groupCache = new HashMap();
    }

    public synchronized void closeAllEntities() {
        for (Integer dsId : datasetCache.values()) {
            closeDataset(dsId);
        }

        datasetCache.clear();

    }

    public int openDataset(String dsName) {
        try {
            Integer dsId = datasetCache.get(dsName);
            if(dsId == null) {
                dsId = H5.H5Dopen(fileId, dsName);
                datasetCache.put(dsName, dsId);
            }
            return dsId;
        } catch (HDF5SymbolTableException ex) {
            throw new ObjectNotFoundException("Error opening dataset: " + dsName);
        } catch (HDF5LibraryException ex) {
            log.error("Error opening dataset", ex);
            throw new RuntimeException(ex);
        }

    }

    /**
     * Close an hdf5 dataset
     */
    private void closeDataset(int datasetId) {

        try {
            H5.H5Dclose(datasetId);
        } catch (HDF5LibraryException ex) {
            log.error("Error closing dataset", ex);
            throw new RuntimeException("Error closing dataset");
        }

    }



    @Override
    protected void finalize() throws Throwable {
        try {
            closeAllEntities();
        } finally {
            super.finalize();
        }
    }
    /*
    static class DatasetReference {
    int datasetId;
    DatasetReference(int datasetId) {
    datasetId = datasetId;
    }
    }
     * */
}
