/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.h5;

import java.io.File;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class H5BinUtils {


    public static void main(String [] args) {
        //String f = "/Users/jrobinso/IGV/TestData/MIP_44.cn.hbin";
        String f = "/Users/jrobinso/IGV/projects/preprocessors/ADSCt1.H3K27me3.aligned.hbin";
        dumpEntities(f);
    }

    public static void dumpEntities(String binFile) {

        H5BinReader reader = new H5BinReader(new File(binFile));

        Map<Integer, H5BinBase.Group> groups = reader.groupCache;
        for(H5BinBase.Group group : groups.values()) {
            group.dump(System.out);
        }

        Map<String, Long> dbIndex = reader.datasetIndex;
        for(String dsname : dbIndex.keySet()) {
            reader.openDataset(dsname);
        }
        for(H5BinBase.Dataset ds : reader.datasetCache.values()) {
            ds.dump(System.out);
        }

    }

}
