/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/




package org.broad.igv.h5;

//~--- JDK imports ------------------------------------------------------------

import java.io.File;
import java.io.FileNotFoundException;

import java.util.HashMap;
import java.util.Map;


/**
 *
 * @author jrobinso
 */
public class BulkPropertyUpdater {

    /**
     * Method description
     *
     *
     * @param args
     */
    public static void main(String[] args) {
        try
        {

            // String h5file = "/Users/jrobinso/IGV/TestData/K562Sequence.h5";
            HashMap properties = new HashMap();
            properties.put("track.autoscale", "false");
            properties.put("track.minValue", 0.0);
            properties.put("track.maxValue", 20.0);

            String dir = "/Volumes/xchip_tcga_scratch/igv/epigenetics/hg18";
            for (File f : (new File(dir)).listFiles())
            {
                String path = f.getAbsolutePath();
                if (path.endsWith("h5"))
                {
                    System.out.println(path);
                    updateFile(path, properties);
                }
            }
        }
        catch (FileNotFoundException ex)
        {
            ex.printStackTrace();
        }
    }

    static void updateFile(String filename, Map<String, String> properties)
            throws FileNotFoundException {

        HDF5LocalWriter writer = new HDF5LocalWriter();

        int fileId = writer.openFile(filename);

        int rootGroupId = writer.openGroup(fileId, "/");

        for (String key : properties.keySet())
        {
            Object value = properties.get(key);

            try
            {
                writer.deleteAttribute(rootGroupId, key);
            }
            catch (DataAccessException e)
            {

                // This is normal if the attribute did not exist.  Ignore.
            }

            writer.writeAttribute(rootGroupId, key, value);

        }

        writer.closeGroup(rootGroupId);

        writer.closeFile(fileId);
    }

}
