/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/





package org.broad.igv.feature;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.data.DatasetParserUtils;
import org.broad.igv.track.TrackProperties;



/**
 *
 * @author jrobinso
 */
abstract public class UCSCParser extends AbstractFeatureParser {

    /**
     * Method description
     *
     *
     * @param nextLine
     *
     * @return
     */
    protected Feature parseLine(String nextLine) {
        String[] tokens = new String[20];

        if (nextLine.startsWith("#"))
        {

            // Skip comments
            return null;
        }
        else if (nextLine.startsWith("track"))
        {
            TrackProperties tp = new TrackProperties();
            DatasetParserUtils.parseTrackLine(nextLine, tp);
            setTrackProperties(tp);
        }

        int nTokens = ParsingUtils.split(nextLine.replaceAll("\"", ""), tokens, '\t');
        return parseLine(tokens, nTokens);
    }

    abstract protected Feature parseLine(String[] tokens, int nTokens);

}
