/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.feature;

import java.io.*;

import java.util.*;

/**
 * Parser for the UCSC snp tracks (e.g. snp128.txt).  
 * @author jrobinso
 */
public class SnpFileParser extends AbstractFeatureParser {

    protected Feature parseLine(String line) throws NumberFormatException {

        String[] tokens = line.replaceAll("\"", "").split("\t");

        int tokenCount = tokens.length;
        int i = 0;
        String chr = tokens[i++];
        int start = Integer.parseInt(tokens[i++]);
        int end = Integer.parseInt(tokens[i++]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            String name = tokens[i++].replaceAll("\"", "");
            feature.setName(name);
        }
        if (tokenCount > 4) {
            float score = Float.parseFloat(tokens[i++]);
            feature.setScore(score);
        }
        if (tokenCount > 5) {
            String strandString = tokens[i++].trim();
            char strand = strandString.length() == 0 ? ' ' : strandString.charAt(0);

            if (strand == '-') {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == '+') {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
       
        // TODO -- rest of fileß

        return feature;
    }

}
