/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.feature;

import org.broad.igv.track.WindowFunction;

/**
 *
 * @author jrobinso
 */
public interface LocusScore {

    public int getStart();

    public void setStart(int start);

    public int getEnd();

    public void setEnd(int end);

    public float getScore();

    public void setConfidence(float confidence);

    public float getConfidence();

    public LocusScore copy();

    /**
     * Return a string to be used for popup text.   The WindowFunction is passed
     * in so it can be used t annotate the value.  The LocusScore object itself
     * does noot "know" from what window function it was derived
     * @param windowFunction
     * @return
     */
    public String getValueString(double position, WindowFunction windowFunction);
}
