/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* GisticScore.java
*
* Created on June 20, 2007, 3:00 PM
*
* To change this template, choose Tools | Template Manager
* and open the template in the editor.
 */

package org.broad.igv.feature;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.track.WindowFunction;

/**
 *
 * @author jrobinso
 */
public class GisticScore implements LocusScore {

    public enum Type { AMP, DEL }
    ;

    // The chromosome/start/end triplet could be encapulated as a "location"
    private String chromosome;
    int start;
    int end;
    private float qValue;
    private float gScore;
    private Type gisticType;

    /** Creates a new instance of GisticScore */
    public GisticScore() {}

    /**
     * Constructs ...
     *
     *
     * @param chr
     * @param start
     * @param end
     * @param qValue
     * @param gScore
     * @param type
     */
    public GisticScore(String chr, int start, int end, float qValue,
                       float gScore, Type type) {
        this.chromosome = chr;
        this.start = start;
        this.end = end;
        this.qValue = qValue;
        this.gScore = gScore;
        this.gisticType = type;
    }

    public GisticScore(GisticScore gisticScore) {
        this.chromosome = gisticScore.chromosome;
        this.start = gisticScore.start;
        this.end = gisticScore.end;
        this.qValue = gisticScore.qValue;
        this.gScore = gisticScore.gScore;
        this.gisticType = gisticScore.gisticType;
    }
    
    public GisticScore copy() {
        return new GisticScore(this);
    }

    public String getChromosome() {
        return chromosome;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getScore() {
        return gScore;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public double getQValue() {
        return qValue;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public double getGScore() {
        return gScore;
    }

    /**
     * Method description
     *
     *
     * @param qValue
     */
    public void setQValue(float qValue) {
        this.qValue = qValue;
    }

    /**
     * Method description
     *
     *
     * @param gScore
     */
    public void setGScore(float gScore) {
        this.gScore = gScore;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Type getType() {
        return gisticType;
    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setType(Type type) {
        this.gisticType = type;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart() {
        return start;
    }

    /**
     * Method description
     *
     *
     * @param start
     */
    public void setStart(int start) {
        this.start = start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getEnd() {
        return end;
    }

    /**
     * Method description
     *
     *
     * @param end
     */
    public void setEnd(int end) {
        this.end = end;
    }

    /**
     * Method description
     *
     *
     * @param confidence
     */
    public void setConfidence(float confidence) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getConfidence() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Method description
     *
     *
     * @param windowFunction
     *
     * @return
     */
    public String getValueString(double position, WindowFunction windowFunction) {
        return "";
    }



}
