/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * GenomeType.java
 *
 * Created on November 8, 2007, 4:20 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 *
 * @author eflakes
 */
public class GenomeDescriptor {

    private String name;
    private int version;
    private String id;
    private String cytoBandFileName;
    private String geneFileName;
    private String geneTrackName;
    private String sequenceLocation;
    private Map<String, ZipEntry> zipEntries;
    private ZipFile genomeZipFile;
    private boolean userDefined;

    public GenomeDescriptor(String name,
            int version,
            String id,
            String cytoBandFileName,
            String geneFileName,
            String geneTrackName,
            String sequenceLocation,
            ZipFile genomeZipFile,
            Map<String, ZipEntry> zipEntries,
            boolean userDefined) {

        this.name = name;
        this.id = id;
        this.cytoBandFileName = cytoBandFileName;
        this.geneFileName = geneFileName;
        this.geneTrackName = geneTrackName;
        this.sequenceLocation = sequenceLocation;
        this.zipEntries = zipEntries;
        this.genomeZipFile = genomeZipFile;
        this.userDefined = userDefined;
    }

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    public String getCytoBandFileName() {
        return cytoBandFileName;
    }

    public String getGeneFileName() {
        return geneFileName;
    }

    public String getGeneTrackName() {
        return geneTrackName;
    }

    public InputStream getCytoBandFileInputStream()
            throws IOException {

        String fileName = getCytoBandFileName();
        if (fileName == null) {
            return null;
        }
        return genomeZipFile.getInputStream(
                (ZipEntry) zipEntries.get(fileName));
    }

    public boolean isCytoBandFileGZipFormat() {
        String fileName = getCytoBandFileName();
        return isFileGZipFormat(fileName);
    }

    public InputStream getGeneFileNameInputStream()
            throws IOException {

        String fileName = getGeneFileName();
        if (fileName == null) {
            return null;
        }
        return genomeZipFile.getInputStream(
                (ZipEntry) zipEntries.get(fileName));
    }

    public boolean isGeneFileGZipFormat() {
        String fileName = getGeneFileName();
        return isFileGZipFormat(fileName);
    }

    public String getSequenceLocation() {
        return sequenceLocation;
    }

    public boolean isUserDefined() {
        return userDefined;
    }

    @Override
    public String toString() {
        return name;
    }

    private boolean isFileGZipFormat(String fileName) {

        if (fileName == null) {
            return false;
        }

        if (fileName.toLowerCase().endsWith(".gz")) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @return the version
     */
    public int getVersion() {
        return version;
    }

    /**
     * @param version the version to set
     */
    public void setVersion(int version) {
        this.version = version;
    }
}
