/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */





package org.broad.igv.feature;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

import org.broad.igv.ui.IGVModel;

//~--- JDK imports ------------------------------------------------------------

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * This is a placeholder class for a true "feature database" wrapper.  Its purpose
 * is to return a feature given a name.  Used to support the "search" box.
 *
 *
 * @author jrobinso
 */
public class FeatureDB {

    private static Logger log = Logger.getLogger(FeatureDB.class);

    /**
     * Map for all features other than genes.
     */
    private static Map<String, Feature> featureMap = new HashMap(10000);

    public static void addFeature(Feature feature) {
        if (feature.getName() != null && feature.getName().length() > 0)
        {
            featureMap.put(feature.getName(), feature);
        }
        if (feature.getIdentifier() != null && feature.getIdentifier().length() > 0)
        {
            featureMap.put(feature.getIdentifier(), feature);
        }
    }

    private FeatureDB() {

        // This class can't be instantiated
    }


    /**
     * Method description
     *
     *
     *
     * @param features
     */
    public static void addFeatures(List<Feature> features) {
        for (Feature feature : features)
        {
            addFeature(feature);
        }
    }

    /**
     * Method description
     *
     */
    public static void clearFeatures() {
        featureMap.clear();
    }

    /**
     * Return the feature, if any, with the given name.  Genes are given
     * precedence.
     *
     * @param name
     * @return
     */
    public static Feature getFeature(String name) {

        // First search genes for current genome.  This obviously needs some refactoring.
        String currentGenome = IGVModel.getInstance().getViewContext().getGenomeId();
        GeneManager gm = GeneManager.getGeneManager(currentGenome);
        Feature gene = null;
        if (gm != null)
        {
            gene = gm.getGene(name);
            if (gene != null)
            {
                return gene;
            }
        }
        return featureMap.get(name);

    }
}
