/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



package org.broad.igv.feature;

import java.awt.Color;

import java.util.List;
import java.util.Map;

/**
 * Interface description
 *
 *
 * @version        Enter version here..., 08/10/16
 * @author         Enter your name here...    
 */
public interface Feature extends LocusScore {

    
    public String getType();
    
    public String getIdentifier();
    
    /**
     * Method description
     *
     *
     * @return
     */
    public String getName();

    /**
     * Method description
     *
     *
     * @return
     */
    public String getDescription();

    
    /**
     * Method description
     *
     *
     * @return
     */
    public boolean hasScore();

    /**
     * Method description
     *
     *
     * @return
     */
    public Strand getStrand();

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean hasStrand();


    /**
     * Method description
     *
     *
     * @return
     */
    public String getChromosome();

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getColor();

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart();

    /**
     * Method description
     *
     *
     * @return
     */
    public int getEnd();

    /**
     * Method description
     *
     *
     * @param feature
     *
     * @return
     */
    public boolean contains(Feature feature);

    /**
     * Method description
     *
     *
     * @return
     */
    public List<Exon> getExons();
    
    public int getLength();
    
    public Map<String, String> getAttributes();

    boolean contains(double location);
    
    

}
