/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/




package org.broad.igv.feature;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

//~--- JDK imports ------------------------------------------------------------

import java.io.*;

import java.util.*;
import org.broad.igv.util.AsciiLineReader;

/**
 * Class description
 *
 *
 * @version    Enter version here..., 08/10/16
 * @author     Enter your name here...
 */
public class CytoBandFileParser {

    private static Logger logger = Logger.getLogger(CytoBandFileParser.class);


    /**
     * Validate cytoband file
     *
     * @param reader
     * @param filename
     * @return
     */
    public static boolean isValid(AsciiLineReader reader, String filename) {

        if (reader == null)
        {
            return false;
        }

        try
        {
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null)
            {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[0].trim();
                Cytoband cytoData = new Cytoband(chr);
                parseData(tokens, cytoData);
            }
            return true;

        }
        catch (Exception e)
        {
            logger.error("Invalid Cytoband file data : file=" + filename, e);
            return false;
        }
    }

    /**
     * Method description
     *
     *
     * @param reader
     *
     * @return
     */
    public static LinkedHashMap<String, Chromosome> loadData(BufferedReader reader) {

        LinkedHashMap<String, Chromosome> dataMap = new LinkedHashMap<String, Chromosome>();
        try
        {

            String nextLine;
            while ((nextLine = reader.readLine()) != null && (nextLine.trim().length() > 0))
            {
                String[] data = nextLine.split("\t");
                String chr = data[0].trim();
                Chromosome chromosome = dataMap.get(chr);
                if (chromosome == null)
                {
                    chromosome = new Chromosome(chr);
                    dataMap.put(chr, chromosome);
                }
                Cytoband cytoData = new Cytoband(chr);
                parseData(data, cytoData);
                chromosome.addCytoband(cytoData);
            }

            reader.close();

        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        return dataMap;

    }

    private static void parseData(String[] tokens, Cytoband cytoData) {

        cytoData.setStart(Integer.parseInt(tokens[1].trim()));
        cytoData.setEnd(Integer.parseInt(tokens[2].trim()));
        if (tokens.length > 3)
        {
            cytoData.setName(tokens[3]);
        }
        if (tokens.length > 4)
        {
            if (tokens[4].equals("acen"))
            {
                cytoData.setType('c');
            }
            else
            {
                cytoData.setType(tokens[4].charAt(1));
                if (cytoData.getType() == 'p')
                {
                    cytoData.setStain(Short.parseShort(tokens[4].substring(4).trim()));
                }
            }
        }

    }

    private static String parseChromosome(String[] data) {
        String chr = data[0].substring(3);
        int underscore = chr.indexOf('_');
        if (underscore > 0)
        {
            chr = chr.substring(0, underscore);
        }
        return chr;
    }
}
