/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.feature;

import java.util.List;

/**
 * Represents an amino acid sequence for an exon
 * @author jrobinso
 */
public class AminoAcidSequence {

    private Strand strand;
    private int startPosition;
    private List<AminoAcid> sequence;
    boolean nonNullSequence;

    public AminoAcidSequence(Strand strand, int startPosition, List<AminoAcid> sequence) {
        this.strand = strand;
        this.startPosition = startPosition;
        this.sequence = sequence;
        
        // Look for a non null sequence.  Sequences are null if the sequence
        // directory is undefined or unreachable.  
        nonNullSequence = false;
        for (AminoAcid aa : sequence) {
            if (aa != null) {
                nonNullSequence = true;
            }
        }
        
    }

    public Strand getStrand() {
        return strand;
    }

    public int getStartPosition() {
        return startPosition;
    }

    public List<AminoAcid> getSequence() {
        return sequence;
    }

    public boolean hasNonNullSequence() {
        return nonNullSequence;
    }
}
