/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.feature;

/**
 *
 * @author jrobinso
 */
public class AminoAcid {

    private String fullName;

    private String abbrevName;

    private char symbol;
    
    public static AminoAcid NULL_AMINO_ACID = new AminoAcid("", "", ' ');

    AminoAcid(String fullName, String abbrevName, char symbol) {
        this.fullName = fullName;
        this.abbrevName = abbrevName;
        this.symbol = symbol;
    }

    public String getFullName() {
        return fullName;
    }

    public String getShortName() {
        return abbrevName;
    }

    public char getSymbol() {
        return symbol;
    }
    
    
    public static void main(String [] args) {
        
        for(int i=0; i<10; i++) {
            System.out.println(i + " " + i%3);
        }
    }
}
