/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/




package org.broad.igv.feature;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;

import java.util.List;
import java.util.Map;


/**
 *
 * @author jrobinso
 */
abstract public class AbstractFeature implements Feature {

    private static Logger log = Logger.getLogger(AbstractFeature.class);

    private Strand strand = Strand.NONE;
    private String chromosome;
    private int start = -1;
    private int end = -1;
    private String type = "";
    protected Color color;
    protected String description;
    private Map<String, String> attributes;

    /**
     * Constructs ...
     *
     */
    public AbstractFeature() {}

    /**
     * Constructs ...
     *
     *
     * @param chr
     * @param start
     * @param end
     * @param strand
     */
    public AbstractFeature(String chr, int start, int end, Strand strand) {
        this.chromosome = ParsingUtils.convertChrString(chr);
        this.start = start;
        this.end = end;
        this.strand = strand;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getIdentifier() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getName() {
        return "";
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public boolean hasScore() {
        return false;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public List<Exon> getExons() {
        return null;
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public float getScore() {
        return Float.NaN;
    }

    /**
     * Method description
     *
     *
     * @param confidence
     */
    public void setConfidence(float confidence) {

        // ignored
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getConfidence() {

        // Obsolete
        return 1.0f;
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public String getChromosome() {
        return chromosome;
    }

    /**
     * By default features are 1 bp wide
     *
     * @return
     */
    public int getEnd() {
        return end;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getLength() {
        return end - start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart() {
        return start;
    }


    /**
     * Return true if the feature is completely contained within the bounds of this
     * featre.
     * 
     * //TODO -- should strand be included in this test?
     *
     *
     * @param feature
     *
     * @return
     */
    public boolean contains(Feature feature) {
        if (feature == null)
        {
            return false;
        }
        if (!this.getChromosome().equals(feature.getChromosome()) ||
            this.getStrand() != feature.getStrand())
        {
            return false;
        }
        if ((feature.getStart() >= this.getStart()) && (feature.getEnd() <= this.getEnd()))
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Method description
     *
     *
     * @param end
     */
    public void setEnd(int end) {
        this.end = end;
    }

    /**
     * Method description
     *
     *
     * @param start
     */
    public void setStart(int start) {
        this.start = start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Strand getStrand() {
        return strand;
    }

    /**
     * Method description
     *
     *
     * @param strand
     */
    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean hasStrand() {
        return ((strand != null) && (strand != Strand.NONE));
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getColor() {
        return color;
    }

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * Method description
     *
     *
     * @param rgb
     */
    public void setColor(String[] rgb, int nTokens) {
        try
        {
            if (nTokens < 3)
            {
                color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[0]),
                                  Integer.parseInt(rgb[0]));
            }
            else
            {
                color = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]),
                                  Integer.parseInt(rgb[2]));
            }
        }
        catch (NumberFormatException numberFormatException)
        {
            log.error("Error parsing color from rgb string: " + rgb[0] + rgb[1] + rgb[2]);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

  
    public String getDescription() {
        return (description == null) ? getName() : description;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean contains(double location) {
        return location >= getStart() && location < getEnd();
    }


}
