/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.data.rnai;

/**
 * A simple value class representing a hairpin score for a specific batch
 * 
 * @author jrobinso
 */
public class RNAIHairpinValue {

    private String name;
    private float scoreMean;
    private float scoreSTD;
    private boolean hasScoreSTD;

    public RNAIHairpinValue(String name, float scoreMean)
    {
        this.name = name;
        this.scoreMean = scoreMean;
        hasScoreSTD = false;
    }
    
    public RNAIHairpinValue(String name, float scoreMean, float scoreSTD) {
        this.name = name;
        this.scoreMean = scoreMean;
        this.scoreSTD = scoreSTD;
        hasScoreSTD = true;
    }
    
    public String getName() {
        return name;
    }

    public float getScoreMean() {
        return scoreMean;
    }

    public float getScoreSTD() {
        return scoreSTD;
    }

    public boolean hasScoreSTD()
    {
        return hasScoreSTD;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final RNAIHairpinValue other = (RNAIHairpinValue) obj;
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 41 * hash + Float.floatToIntBits(this.scoreMean);
        hash = 41 * hash + Float.floatToIntBits(this.scoreSTD);
        return hash;
    }
    
    
}

