/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.LocusScore;

/**
 * Represents a chunk of data over a fixed window span (default == 1)
 * @version 1.0
 * @created 13-Nov-2007 13:11:15
 */
public class SummaryTile2D  {
    
    /**
     * The tileNumber.  Used to support unit tests, and  general  debugging
     */
    private int tileNumber;
    private int startLocation;
    
    Map<Integer,List<LocusScore>> summaryScores;
    
    public SummaryTile2D(int tileNumber, int startLocation){
        this.tileNumber = tileNumber;
        this.startLocation = startLocation;
        summaryScores = new HashMap();
    }
    
    public void addScore(int trackNumber, LocusScore score) {
        List<LocusScore> scoreList = summaryScores.get(trackNumber);
        if(scoreList == null) {
            scoreList = new ArrayList();
            summaryScores.put(trackNumber, scoreList);
        }
        scoreList.add(score);
    }
    
    public List<LocusScore> getScores(int trackNumber) {
        return summaryScores.get(trackNumber);
    }
    
    public Map<Integer, List<LocusScore>> getSummaryScores() {
        return summaryScores;
    }
    
    public int getSize() {
        return summaryScores.size();
    }
    
    public boolean isEmpty() {
        return summaryScores.isEmpty();
    }
    
    public int getStartLocation() {
        return startLocation;
    }
    
    
}
