/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



package org.broad.igv.data;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.feature.LocusScore;

//~--- JDK imports ------------------------------------------------------------

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Represents a chunk of data over a fixed window span (default == 1)
 * @version 1.0
 * @created 13-Nov-2007 13:11:15
 */
public class SummaryTile {

    /**
     * The tileNumber.  Used to support unit tests, and  general  debugging
     */
    private int tileNumber;
    private int startLocation;

    List<LocusScore> summaryScores;

    /**
     * Constructs ...
     *
     *
     * @param tileNumber
     * @param startLocation
     */
    public SummaryTile(int tileNumber, int startLocation) {
        this.tileNumber = tileNumber;
        this.startLocation = startLocation;
        summaryScores = new ArrayList(1000);
    }

    /**
     * Method description
     *
     *
     * @param score
     */
    public void addScore(LocusScore score) {
        summaryScores.add(score);
    }

    /**
     * Method description
     *
     *
     * @param scores
     */
    public void addAllScores(Collection<LocusScore> scores) {
        summaryScores.addAll(scores);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public List<LocusScore> getScores() {
        return summaryScores;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getSize() {
        return summaryScores.size();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isEmpty() {
        return summaryScores.isEmpty();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStartLocation() {
        return startLocation;
    }


}
