/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

/**
 *
 * @author jrobinso
 */
public class SummaryScore implements LocusScore {

    int start;
    int end;
    float value;
    float confidence;

    public SummaryScore(int start, int end, float value, float confidence) {
        this.start = start;
        this.end = end;
        this.value = value;
        this.confidence = confidence;
    }

    public SummaryScore(LocusScore anotherScore) {
        this.start = anotherScore.getStart();
        this.end = anotherScore.getEnd();
        this.value = anotherScore.getScore();
        this.confidence = anotherScore.getConfidence();
    }

    public SummaryScore copy() {
        return new SummaryScore(this);
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return start;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public float getValue() {
        return value;
    }

    public void setScore(float score) {
        this.value = score;
    }

    public float getScore() {
        return value;
    }

    public float getConfidence() {
        return confidence;
    }

    public String getValueString(double position, WindowFunction wf) {
        return "Value:  " + getScore() + (wf == null ? "" : " (" + wf.toString() + ")");
    }

    public void setConfidence(float confidence) {
        this.confidence = confidence;
    }

    public int getExtendedStart() {
        return getStart();
    }

    public int getExtendedEnd() {
        return getEnd();
    }
}
