/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.data;

/**
 *
 * @author jrobinso
 */
public class StringArrayList {
    
    static final int maxGrowIncrement = Integer.MAX_VALUE / 10;
    
    int size = 0;
    String [] values;
    
    public StringArrayList(int maxSize) {
        values = new String[maxSize];
    }
    
    public void add(String v) {
        if(size >= values.length) {
            grow();
        }
        values[size] = v;
        size++;
    }
    
    public String [] toArray() {
        trim();
        return values;
    }
    
    private void grow() {
        if(values.length >= Integer.MAX_VALUE) {
            throw new RuntimeException("Maximum array size exceeded");
        }
        int increment = (int)   (Math.max(1000, 0.2 * values.length));
        int newSize = Math.min(Integer.MAX_VALUE, values.length + increment);
        resize(newSize);
        
    }

    private void resize(int newSize) {
        String[] tmp = new String[newSize];
        System.arraycopy(values, 0, tmp, 0, Math.min(tmp.length, values.length));
        values = tmp;
    }
    
    private void trim() {
        resize(size);
    }

}
