/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

//~--- non-JDK imports --------------------------------------------------------
import org.broad.igv.IGVConstants;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

//~--- JDK imports ------------------------------------------------------------

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * TODO -- THIS IS NEARLY AN EXACT COPY OF SegmentedDataSource,  only the
 * dataset type is different.
 *
 * @author jrobinso
 */
public class SegmentedDataSource implements DataSource {

    /**
     * Identifies the track.  Often a sample name.
     */
    String trackIdentifier;
    SegmentedDataSet dataset;

    /**
     * Constructs ...
     *
     *
     * @param trackIdentifier
     * @param dataset
     */
    public SegmentedDataSource(String trackIdentifier, SegmentedDataSet dataset) {
        this.trackIdentifier = trackIdentifier;
        this.dataset = dataset;
    }

    /**
     * Method description
     *
     *
     * @param timestamp
     */
    public void refreshData(long timestamp) {
        dataset.refreshData(timestamp);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public TrackType getTrackType() {
        return dataset.getType();
    }

    /**
     * Method description
     *
     *
     * @param statType
     */
    public void setWindowFunction(WindowFunction statType) {

        // ignore
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogNormalized() {
        return dataset.isLogNormalized();
    }

    /**
     * Method description
     *
     *
     * @param chr
     *
     * @return
     */
    public double getDataMax(String chr) {
        return dataset.getDataMax(chr);
    }

    /**
     * Method description
     *
     *
     * @param chr
     *
     * @return
     */
    public double getDataMin(String chr) {
        return dataset.getDataMin(chr);
    }

    /**
     * Method description
     *
     *
     * @param zoom
     * @param chr
     *
     * @return
     */
    public double getMedian(int zoom, String chr) {
        return 1.0;
    }

    private List<LocusScore> getSegments(String chr) {

        return dataset.getSegments(trackIdentifier, chr);

    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param startLocation
     * @param endLocation
     * @param zoom
     *
     * @return
     */
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation,
            int endLocation, int zoom) {
        if (chr.equals(IGVConstants.CHR_ALL)) {
            return getWholeGenomeScores();
        }
        return getSegments(chr);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public List<LocusScore> getWholeGenomeScores() {
        return dataset.getWholeGenomeScores(trackIdentifier);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public WindowFunction getWindowFunction() {
        return null;
    }
}
