/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.util.ResourceLocator;

/**
 *
 * @author jrobinso
 */
public class SegmentedBinaryRemoteReader implements SegmentedBinaryReader {

    static Logger log = Logger.getLogger(SegmentedBinaryRemoteReader.class);

    String serverURL;

    String filePath;

    Map<String, String> attributes;

    public SegmentedBinaryRemoteReader(ResourceLocator locator) {
        this.serverURL = locator.getServerURL();
        this.filePath = locator.getPath();
    }

    public SegmentedChromosomeData getChromosomeData(String chr) {
        
        InputStream is = null;
        try {
            URL url = new URL(serverURL + "?method=getChromosomeData&file=" +
                    filePath + "&chr=" + chr);
            URLConnection connection = url.openConnection();
            SegmentedChromosomeData cd = new SegmentedChromosomeData();
            is = connection.getInputStream();
            cd.deserialize(is);
            return cd;
        } 
        catch (IOException ex) {
            log.error("Error opening file", ex);
            throw new RuntimeException(ex);
        } finally {
            if (is != null) {
                try {
                    is.close();

                } catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }

        }
    }

    public List<String> getSampleNames() {
        InputStream urlStream = null;

        try {
            List<String> childNames = new ArrayList(100);
            URL url = new URL(serverURL + "?method=getSampleNames&file=" + filePath);
            URLConnection connection = url.openConnection();

            urlStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                childNames.add(nextLine.trim());
            }
            reader.close();
            return childNames;

        } catch (IOException ex) {
            //log.error("Error in getChildNames", ex);   
            throw new RuntimeException(ex);
        } finally {
            if (urlStream != null) {
                try {
                    urlStream.close();

                } catch (IOException iOException) {
                    log.error("Error closing URL stream", iOException);
                }
            }

        }
    }
    /*
     *             
    List<String> lines = readAsStrings("data/attributes.txt");
    if (lines != null) {
    for (String kv : lines) {
    String[] tokens = kv.split("\t");
    attrs.put(tokens[0], tokens[1]);
    }
    }
     */

    public String getStringAttribute(String key) {
        if (attributes == null) {
            attributes = new HashMap();
            InputStream urlStream = null;
            
            try {
                URL url = new URL(serverURL + "?method=getAttributes&file=" + filePath);
                URLConnection connection = url.openConnection();

                urlStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(urlStream));
                String nextLine = "";
                while ((nextLine = reader.readLine()) != null) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length > 1) {
                        attributes.put(tokens[0], tokens[1]);
                    }
                }

                reader.close();

            } catch (IOException ex) {
                log.error("Error in getChildNames", ex);

            } finally {
                if (urlStream != null) {
                    try {
                        urlStream.close();

                    } catch (IOException iOException) {
                        log.error("Error closing URL stream", iOException);
                    }
                }

            }
        }
        return attributes.get(key);

    }
}
