/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.data;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;

/**

 * @version    Enter version here..., 09/01/09
 * @author     Enter your name here...
 */
public class Segment implements LocusScore {

    private int extendedStart = -1;
    private int extendedEnd = -1;
    private int start;
    private int end;
    private float score;
    private int snpCount;

    public Segment(int start, int end, float score) {
        this(start, end, score, 0);
    }

    public Segment(int start, int end, float score, int snpCount) {
        this.start = start;
        this.end = end;
        if (extendedStart < 0) {
            extendedStart = start;
        }
        if (extendedEnd < 0) {
            extendedEnd = end;
        }
        this.score = score;
        this.snpCount = snpCount;
    }


    //Segment(int start, int end,  float score, int snpCount) {
    //    this(start, start, end, end, score, snpCount);
    //}
    public Segment(int start, int origStart, int end, int origEnd, float score, int snpCount) {
        this.start = start;
        this.end = end;
        this.extendedStart = origStart;
        this.extendedEnd = origEnd;
        this.score = score;
        this.snpCount = snpCount;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Segment copy() {
        return new Segment(start, extendedStart, end, extendedEnd, score, snpCount);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart() {
        return start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getEnd() {
        return end;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getScore() {
        return score;
    }

    /**
     * Method description
     *
     *
     * @param start
     */
    public void setStart(int start) {
        this.start = start;
    }

    /**
     * Method description
     *
     *
     * @param end
     */
    public void setEnd(int end) {
        this.end = end;
    }

    /**
     * Method description
     *
     *
     * @param confidence
     */
    public void setConfidence(float confidence) {

        // Ignored for now
        }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getConfidence() {
        return 1.0f;
    }

    /**
     * Method description
     *
     *
     * @param position
     * @param ignored
     *
     * @return
     */
    public String getValueString(double position, WindowFunction ignored) {
        String valueString = "Copy number: " + getScore();
        if (snpCount > 0) {
            valueString += " (" + snpCount + " markers)";
        }
        return valueString;
    }

    /**
     * Method description
     *
     *
     * @param inc
     */
    public void incremenetSnpCount(int inc) {
        snpCount += inc;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getSnpCount() {
        return snpCount;
    }

    /**
     * @return the extendedStart
     */
    public int getExtendedStart() {
        return extendedStart;
    }

    /**
     * @return the extendedEnd
     */
    public int getExtendedEnd() {
        return extendedEnd;
    }

    /**
     * @param extendedStart the extendedStart to set
     */
    public void setExtendedStart(int extendedStart) {
        this.extendedStart = extendedStart;
    }

    /**
     * @param extendedEnd the extendedEnd to set
     */
    public void setExtendedEnd(int extendedEnd) {
        this.extendedEnd = extendedEnd;
    }
}
