/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ProbeSet.java
 *
 * Created on October 31, 2007, 5:18 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author jrobinso
 */
public class ProbeSet {
    
    private Map<String, List<ExpressionProbe>> probeLists = new HashMap();
    private Map<String, ExpressionProbe> probes = new HashMap();

    public Set<String> getChromosomes() {
        return probeLists.keySet();
    }


    public List<ExpressionProbe> getProbes(String chr) {
        return probeLists.get(chr);
    }
    
    public ExpressionProbe getProbe(String probeId) {
        return probes.get(probeId);
    }

    public void add(ExpressionProbe probe) {
        probes.put(probe.getName(), probe);
        List<ExpressionProbe> pList = probeLists.get(probe.getChr());
        if(pList == null) {          
            pList = new ArrayList(1000);
            probeLists.put(probe.getChr(), pList);           
        }
        pList.add(probe);       
    }
    
    public void sortProbeLists() {
        for(List<ExpressionProbe> list : probeLists.values()) {
            Collections.sort(list);
        }
    }
    
    
    
}
