/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

import org.broad.igv.track.WindowFunction;

/**
 * This is basically a feature.
 *
 * //TODO -- there are too many of these classes,  redesign.
 *
 * @author jrobinso
 */
public class NamedSummaryScore extends SummaryScore {

    String featureName;

    public NamedSummaryScore(int start, int end, float value, String featureName) {
        super(start, end, value, 1.0f);
        this.featureName = featureName;
    }

    @Override
    public NamedSummaryScore copy() {
        return new NamedSummaryScore(getStart(), getEnd(), getScore(), featureName);
    }


    @Override
    public String getValueString(double position, WindowFunction wf) {
        return featureName + ":   " + getScore();
    }
}
