/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.data;

import com.mindprod.ledatastream.*;
import java.io.*;

/**
 *
 * @author jrobinso
 */
public class LEDTest {

    static int nPts = 5000000;

    public static void main(String[] args) {
        File ledFile = new File("ledtest.bin");
        writeLED(ledFile);
        writeBin(ledFile);
    }

    static void writeLED(File file) {

        OutputStream os = null;
        InputStream is = null;

        try {
            long t0 = System.currentTimeMillis();
            os = new BufferedOutputStream(new FileOutputStream(file));
            LEDataOutputStream ledOS = new LEDataOutputStream(os);

            for (int i = 0; i < nPts; i++) {
                ledOS.writeDouble(i * 1.0);
            }
            System.out.println("LE: wrote " + nPts + " doubles in " + (System.currentTimeMillis() - t0));
            os.close();

            t0 = System.currentTimeMillis();
            is = new BufferedInputStream(new FileInputStream(file));
            LEDataInputStream ledIS = new LEDataInputStream(is);
            for (int i = 0; i < nPts; i++) {
                double t = ledIS.readDouble();
                if (i * 1.0 != t) {
                    System.out.println("Error");
                }
            }
            System.out.println("LE: read " + nPts + " doubles in " + (System.currentTimeMillis() - t0));
            is.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void writeBin(File file) {

        OutputStream os = null;
        InputStream is = null;

        try {
            long t0 = System.currentTimeMillis();
            os = new BufferedOutputStream(new FileOutputStream(file));
            DataOutputStream ledOS = new DataOutputStream(os);

            for (int i = 0; i < nPts; i++) {
                ledOS.writeDouble(i * 1.0);
            }
            System.out.println("BE: wrote " + nPts + " doubles in " + (System.currentTimeMillis() - t0));
            os.close();

            t0 = System.currentTimeMillis();
            is = new BufferedInputStream(new FileInputStream(file));
            DataInputStream ledIS = new DataInputStream(is);
            for (int i = 0; i < nPts; i++) {
                double t = ledIS.readDouble();
                if (i * 1.0 != t) {
                    System.out.println("Error");
                }
            }
            System.out.println("BE: read " + nPts + " doubles in " + (System.currentTimeMillis() - t0));
            is.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
