/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and openFile the template in the editor.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public class HDFDataSource implements DataSource {

    private String name;
    private int trackNumber;  // Order in HDF5File

    //private int version;
    HDFDataManager dataManager;

    public HDFDataSource(HDFDataManager dataManager, String name, int trackNumber) {

        this.dataManager = dataManager;
        this.name = name;
        this.trackNumber = trackNumber;

    }
    
    public boolean isCopyNumber() {
        TrackType tt = dataManager.getTrackType();
        return tt == TrackType.COPY_NUMBER || tt == TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
    }

    String getName() {
        return name;
    }

    public TrackType getTrackType() {
        return dataManager.getTrackType();
    }

    public void setWindowFunction(WindowFunction statType) {
        dataManager.setWindowFunction(statType);
    }

    public boolean isLogNormalized() {
        return dataManager.isNormalized();
    }

    public int getChrLength(String chr) {
        return dataManager.getChrLength(chr);
    }

    public double getDataMax(String chr) {
        return dataManager.getDataMax(trackNumber, chr);
    }

    public double getDataMin(String chr) {
        return dataManager.getDataMin(trackNumber, chr);
    }

    /**
     * Refresh the data 
     */
    public void refresh() {
    // TODO -- implementation.  Clear caches, etc.
    }
    /**
     * 
     * @param trackNumber
     * @param chr
     * @param startLocation
     * @param endLocation
     * @param zoom
     * @param windowFunction
     * @return
     */
    
    // TDO -- without caching the lastTileList the app hangs in some rare cases
    //  FIGURE OUT WHY!!!
    private static String lastTileListKey = null;
    private static List<SummaryTile2D> lastTileList = null;

    public List<LocusScore> getSummaryScoresForRange(
        String chr, int startLocation, int endLocation, int zoom) {

        List<SummaryTile2D> tiles = null;
        String key = dataManager.hashCode() + "_" +
            chr + " " + startLocation + "_" + endLocation + "_" +
            zoom + getWindowFunction().toString();
        if (lastTileListKey != null && lastTileListKey.equals(key)) {
            tiles = lastTileList;
        } else {
            tiles = dataManager.getSummaryTilesForRange(chr, startLocation, endLocation, zoom);
            lastTileListKey = key;
            lastTileList = tiles;
        }

         boolean aggregate = false;
         //boolean aggregate = PreferenceManager.getInstance().isJoinAdjacentSegments();

        // If copy # optionally join segments with identical values
        if (aggregate && (getTrackType() == TrackType.COPY_NUMBER) ||
            (getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER)) {
            return aggregateScores(trackNumber, tiles);
        } else {
            List<LocusScore> summaryScores = new ArrayList(tiles.size() * 700);

            // TODO -- refactor this for efficiency.  Features can be returned from multiple
            // tiles if they overlap the tiles.  However we only want to count them once.
            //HashSet<String> locusKeys = new HashSet();
            for (SummaryTile2D tile : tiles) {
                if (!tile.isEmpty()) {
                    List<LocusScore> scores = tile.getScores(trackNumber);
                    if (scores != null) {
                        summaryScores.addAll(tile.getScores(trackNumber));
                    }
                //    for (LocusScore score : tile.getScores()) {
                //        String key = score.getStart() + "_" + score.getEnd();
                //        if (!locusKeys.contains(key)) {
                //            summaryScores.add(score);
                //            locusKeys.add(key);
                //       }
                //   }
                }
            }

            return summaryScores;
        }
    }

    private List<LocusScore> aggregateScores(int trackNumber, List<SummaryTile2D> tiles) {
        List<LocusScore> joinedScores = new ArrayList(tiles.size() * 700);
        LocusScore previousScore = null;

        for (SummaryTile2D tile : tiles) {
            if (tile.getScores(trackNumber) != null) {
                for (LocusScore score : tile.getScores(trackNumber)) {
                    if (!Float.isNaN(score.getScore())) {

                        if (previousScore == null) {
                            previousScore = new SummaryScore(score);
                            joinedScores.add(previousScore);
                        } else {
                            if (score.getScore() == previousScore.getScore()) {
                                // score values are identical, stretch the current score
                                // The only purpose of this is to reconsitute segmented data from
                                // cn files that were created from cbs (segmented) files.  This
                                // really doesn'tileNumber belong in IGV.
                                previousScore.setEnd(score.getEnd());
                                previousScore.setConfidence(1);

                            } else {

                                SummaryScore newScore = new SummaryScore(score);

                                // score value has changed. Adjust end of previous
                                // score (if any), and start of this score to meet 1/2
                                // way
                                int delta = newScore.getStart() - previousScore.getEnd();
                                previousScore.setEnd(previousScore.getEnd() + delta / 2);
                                newScore.setStart(previousScore.getEnd());

                                joinedScores.add(newScore);

                                previousScore = newScore;
                            }

                        }
                    }
                }

            }
        }


        return joinedScores;
    }

    public void refreshData(long timestamp) {
    // ignored for now
    }

    public Collection<WindowFunction> getAvailableWindowFunctions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WindowFunction getWindowFunction() {
        return dataManager.getWindowFunction();
    }
}
